/*
 * Decompiled with CFR 0.152.
 */
package com.github.promeg.pinyinhelper;

import com.github.promeg.pinyinhelper.Pinyin;
import com.github.promeg.pinyinhelper.PinyinDict;
import com.github.promeg.pinyinhelper.SegmentationSelector;
import com.github.promeg.pinyinhelper.Utils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.ahocorasick.trie.Emit;
import org.ahocorasick.trie.Trie;

final class Engine {
    static final EmitComparator EMIT_COMPARATOR = new EmitComparator();

    private Engine() {
    }

    static String toPinyin(String inputStr, Pinyin.Config config, String separator) {
        List<PinyinDict> pinyinDicts = Collections.unmodifiableList(config.getPinyinDicts());
        Trie trie = Utils.dictsToTrie(config.getPinyinDicts());
        SegmentationSelector selector = config.getSelector();
        return Engine.toPinyin(inputStr, trie, pinyinDicts, separator, selector);
    }

    static String toPinyin(String inputStr, Trie trie, List<PinyinDict> pinyinDictList, String separator, SegmentationSelector selector) {
        if (inputStr == null || inputStr.length() == 0) {
            return inputStr;
        }
        if (trie == null || selector == null) {
            StringBuffer resultPinyinStrBuf = new StringBuffer();
            for (int i = 0; i < inputStr.length(); ++i) {
                resultPinyinStrBuf.append(Pinyin.toPinyin(inputStr.charAt(i)));
                if (i == inputStr.length() - 1) continue;
                resultPinyinStrBuf.append(separator);
            }
            return resultPinyinStrBuf.toString();
        }
        List<Emit> selectedEmits = selector.select(trie.parseText((CharSequence)inputStr));
        Collections.sort(selectedEmits, EMIT_COMPARATOR);
        StringBuffer resultPinyinStrBuf = new StringBuffer();
        int nextHitIndex = 0;
        int i = 0;
        while (i < inputStr.length()) {
            if (nextHitIndex < selectedEmits.size() && i == selectedEmits.get(nextHitIndex).getStart()) {
                String[] fromDicts = Engine.pinyinFromDict(selectedEmits.get(nextHitIndex).getKeyword(), pinyinDictList);
                for (int j = 0; j < fromDicts.length; ++j) {
                    resultPinyinStrBuf.append(fromDicts[j].toUpperCase());
                    if (j == fromDicts.length - 1) continue;
                    resultPinyinStrBuf.append(separator);
                }
                i += selectedEmits.get(nextHitIndex).size();
                ++nextHitIndex;
            } else {
                resultPinyinStrBuf.append(Pinyin.toPinyin(inputStr.charAt(i)));
                ++i;
            }
            if (i == inputStr.length()) continue;
            resultPinyinStrBuf.append(separator);
        }
        return resultPinyinStrBuf.toString();
    }

    static String[] pinyinFromDict(String wordInDict, List<PinyinDict> pinyinDictSet) {
        if (pinyinDictSet != null) {
            for (PinyinDict dict : pinyinDictSet) {
                if (dict == null || dict.words() == null || !dict.words().contains(wordInDict)) continue;
                return dict.toPinyin(wordInDict);
            }
        }
        throw new IllegalArgumentException("No pinyin dict contains word: " + wordInDict);
    }

    static final class EmitComparator
    implements Comparator<Emit> {
        EmitComparator() {
        }

        @Override
        public int compare(Emit o1, Emit o2) {
            if (o1.getStart() == o2.getStart()) {
                return o1.size() < o2.size() ? 1 : (o1.size() == o2.size() ? 0 : -1);
            }
            return o1.getStart() < o2.getStart() ? -1 : (o1.getStart() == o2.getStart() ? 0 : 1);
        }
    }
}

